/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.gui.actorbar;

import com.quantumdata.sct.gui.common.SCTButton;
import com.quantumdata.sct.gui.common.SCTConstants;
import com.quantumdata.sct.gui.common.SCTPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public abstract class AbstractActorBar
extends SCTPanel
implements ActionListener {
    public static final short HORIZONTAL = 1;
    public static final short VERTICAL = 2;
    private short m_orientation;
    protected int m_lastPressedBtnIdx;
    protected SCTButton[] buttons;

    public AbstractActorBar(short s) {
        this.m_orientation = s;
    }

    public AbstractActorBar(int n, short s) {
        this.buttons = new SCTButton[n];
        this.m_orientation = s;
    }

    protected void setButtonCount(int n) {
        this.buttons = new SCTButton[n];
    }

    protected short getOrientation() {
        return this.m_orientation;
    }

    public int getLastSelectedIndex() {
        return this.m_lastPressedBtnIdx;
    }

    protected void setLastSelected(int n) {
        this.m_lastPressedBtnIdx = n;
    }

    public void initializeGUI() {
        this.addButtons();
        this.setBackground(SCTConstants.DIALOG_BG_COLOR);
        if (this.m_orientation == 2) {
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 11;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 1, 1, 1);
            SCTPanel sCTPanel = new SCTPanel(new BorderLayout());
            SCTPanel sCTPanel2 = new SCTPanel(gridBagLayout);
            for (int i = 0; i < this.buttons.length; ++i) {
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = i;
                gridBagLayout.setConstraints(this.buttons[i], gridBagConstraints);
                sCTPanel2.add(this.buttons[i]);
            }
            sCTPanel.add((Component)sCTPanel2, "North");
            this.add(sCTPanel);
        } else {
            this.setLayout(new FlowLayout(1, 0, 5));
            for (int i = 0; i < this.buttons.length; ++i) {
                this.add(this.buttons[i]);
            }
        }
    }

    public abstract void addButtons();

    public void setSelectedButton(int n) {
        this.m_lastPressedBtnIdx = n;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.buttons == null) {
            return;
        }
        for (int i = 0; i < this.buttons.length; ++i) {
            if (actionEvent.getSource() != this.buttons[i]) continue;
            this.setSelectedButton(i);
        }
    }
}

